#!/bin/sh
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

PROCESS_ALIVE=0
PROCESS_PID=0

CheckIfDaemonAlive(){
    PROCESS_ALIVE=0
    if [ -f "$1" ]; then
        PROCESS_PID=`cat $1`
        kill -0 ${PROCESS_PID}
        if [ "0" = "$?" ]; then
            PROCESS_ALIVE=1
        fi
    fi
}

SYSLOGNG_ARCH_BIN=/usr/syno/sbin/synologarchd
SYSLOGNG_ARCH_PID_FILE=/var/run/logdispatchd.pid

SyslogAccountingReload(){
    CheckIfDaemonAlive ${SYSLOGNG_ARCH_PID_FILE}
    if [ "1" = "$PROCESS_ALIVE" ]; then
        kill -HUP ${PROCESS_PID}
        sleep 1;
    else
        ${SYSLOGNG_ARCH_BIN}
    fi
}


IsServiceEnable(){
    SERVICE_ENABLE=0
    synoservicecfg --is-enabled $1
    if [ "1" = "$?" ]; then
        SERVICE_ENABLE=1
    fi
}

IsServiceRunning(){
    SERVICE_RUNNING=0
    synoservicecfg --status $1
    if [ "0" = "$?" ]; then
        SERVICE_RUNNING=1
    fi
}

SearviceRestart(){
    IsServiceRunning $1

    if [ "1" == ${SERVICE_RUNNING} ]; then
        synoservicecfg --reload $1
    else
        synoservicecfg --soft-start $1
    fi
}
